import torch
import torch.nn as nn
import torch.optim as optim

class Generator(nn.Module):
    def __init__(self, x_dim=1, noise_dim=3, y_dim=2):
        super().__init__()
        self.model = nn.Sequential(
            nn.Linear(x_dim + noise_dim, 50),
            nn.ReLU(),
            nn.Linear(50, 25),
            nn.ReLU(),
            nn.Linear(25, y_dim)
        )

    def forward(self, x, eta):
        return self.model(torch.cat([x, eta], dim=1))

class Generator2(nn.Module):
    def __init__(self, x_dim=1, noise_dim=3, y_dim=2):
        super().__init__()
        self.model = nn.Sequential(
            nn.Linear(x_dim + noise_dim, 50),
            nn.ReLU(),
            nn.Linear(50, 50),
            nn.ReLU(),
            nn.Linear(50, y_dim)
        )

    def forward(self, x, eta):
        return self.model(torch.cat([x, eta], dim=1))

class Discriminator(nn.Module):
    def __init__(self, x_dim=1, y_dim=2):
        super().__init__()
        self.model = nn.Sequential(
            nn.Linear(x_dim + y_dim, 50),
            nn.ReLU(),
            nn.Linear(50, 25),
            nn.ReLU(),
            nn.Linear(25, 1)
        )

    def forward(self, x, y):
        return self.model(torch.cat([x, y], dim=1))